<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: lang_verify
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_lang_verify($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrDeveloper');

    // get our items
    // find how many lines we are showing
    if (!isset($_post['p']) || !jrCore_checktype($_post['p'], 'number_nz')) {
        $_post['p'] = 1;
    }
    $_sp = array(
        'pagebreak'     => jrCore_get_pager_rows(),
        'page'          => $_post['p'],
        'order_by'      => array(
            'log_module'   => 'desc',
            'log_db_value' => 'desc'
        ),
        'group_by'      => 'log_db_value',
        'skip_triggers' => true
    );
    $_rt = jrCore_db_search_items('jrDeveloper', $_sp);

    // start our html output
    $url = jrCore_get_module_url('jrDeveloper');
    $url = "{$_conf['jrCore_base_url']}/{$url}/lang_verify_delete_all";
    $btn = jrCore_page_button('delete', 'Empty', "jrCore_confirm('Delete the Language Log?', '', function(){ jrCore_window_location('{$url}') })");

    jrCore_page_banner('Language Verify Log', $btn);
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'Module';
    $dat[1]['width'] = '2%';
    $dat[2]['title'] = 'ID';
    $dat[2]['width'] = '2%';
    $dat[3]['title'] = 'Database Value';
    $dat[3]['width'] = '30%';
    $dat[4]['title'] = 'Template Value';
    $dat[4]['width'] = '30%';
    $dat[5]['title'] = 'Location';
    $dat[5]['width'] = '36%';
    jrCore_page_table_header($dat);
    unset($dat);

    if ($_rt && is_array($_rt) && isset($_rt['_items'])) {

        foreach ($_rt['_items'] as $item) {
            $dat = array();
            if (isset($_mods["{$item['log_module']}"])) {
                $dat[1]['title'] = jrCore_get_module_icon_html($item['log_module'], 32);
            }
            else {
                $dat[1]['title'] = jrCore_get_skin_icon_html($item['log_module'], 32);
            }
            $dat[2]['title'] = $item['log_id'];
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = htmlentities($item['log_db_value']);
            $dat[4]['title'] = htmlentities($item['log_skin_value']);
            $dat[5]['title'] = $item['log_tpl'];
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_rt);
    }
    else {
        $dat             = array();
        $dat[1]['title'] = '<p>There are no language strings to show in the Language Log</p>';
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    jrCore_page_display();
}
