<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: package_module
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_package_module($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    if (!isset($_conf['jrDeveloper_developer_prefix']) || strlen($_conf['jrDeveloper_developer_prefix']) === 0 || !isset($_conf['jrDeveloper_developer_name']) || strlen($_conf['jrDeveloper_developer_name']) === 0) {
        jrCore_set_form_notice('error', 'You have not set your Developer Name or Developer Prefix - both are required to package a module or skin');
        $hl = '';
        if (!isset($_conf['jrDeveloper_developer_prefix']) || strlen($_conf['jrDeveloper_developer_prefix']) === 0) {
            $hl .= '/hl[]=developer_prefix';
        }
        if (!isset($_conf['jrDeveloper_developer_name']) || strlen($_conf['jrDeveloper_developer_name']) === 0) {
            $hl .= '/hl[]=developer_name';
        }
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/global{$hl}");
    }
    if (isset($_conf['jrDeveloper_template_debug']) && $_conf['jrDeveloper_template_debug'] == 'on') {
        jrCore_set_form_notice('error', 'Disable template debug mode before packaging modules to avoid template names appearing in parsed templates.');
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/global/hl[]=template_debug");
    }

    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrDeveloper');

    $missing = false;
    if (isset($_post['show_unreleased']) && $_post['show_unreleased'] == '1') {
        $missing = true;
    }

    // modules ahead of the marketplace:
    $_ahead = array();
    $_ver   = jrMarket_get_system_updates(true);
    if ($_ver && is_array($_ver)) {
        foreach ($_mods as $nam => $_inf) {
            // same versions
            if (!$missing && (!isset($_ver['module'][$nam]['v']) || strlen($_ver['module'][$nam]['v']) === 0)) {
                continue;
            }
            // not my module, continue
            if (strpos(' ' . $_inf['module_directory'], $_conf['jrDeveloper_developer_prefix']) != 1) {
                continue;
            }

            // Get version ON DISK if we can
            $vers          = jrDeveloper_get_local_module_version($nam);
            $check_version = ($vers) ? $vers : $_ver['module'][$nam]['v'];
            if (($missing && !isset($_ver['module'][$nam])) || $check_version != $_ver['module'][$nam]['v']) {
                $_ahead[$nam] = array(
                    'directory' => $_inf['module_directory'],
                    'name'      => $_inf['module_name'],
                    'local'     => $check_version,
                    'market'    => (!empty($_ver['module'][$nam]['v'])) ? $_ver['module'][$nam]['v'] : ''
                );
            }
        }
    }

    if (!empty($_ahead)) {
        uasort($_ahead, function($a, $b) {
            return (strcasecmp($a['name'], $b['name']));
        });
        if ($missing) {
            $button = jrCore_page_button("show-missing", 'Hide Unreleased', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/package_module')");
        }
        else {
            $button = jrCore_page_button("show-missing", 'Show Unreleased', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/package_module/show_unreleased=1')");
        }
        jrCore_page_banner('marketplace version differences', $button);

        // Start our output
        $dat             = array();
        $dat[1]['title'] = 'icon';
        $dat[1]['width'] = '1%';
        $dat[2]['title'] = 'module name';
        $dat[2]['width'] = '49%';
        $dat[3]['title'] = 'directory';
        $dat[3]['width'] = '20%';
        $dat[4]['title'] = 'local';
        $dat[4]['width'] = '10%';
        $dat[5]['title'] = 'marketplace';
        $dat[5]['width'] = '10%';
        jrCore_page_table_header($dat);

        // versions ahead the marketplace
        foreach ($_ahead as $_v) {
            $_md             = jrCore_module_meta_data($_v['directory']);
            $dat             = array();
            $dat[1]['title'] = jrCore_get_module_icon_html($_v['directory'], 32);
            $dat[2]['title'] = '<a onclick="var z=$(\'#zip_mod\'); z.val(\'' . $_v['directory'] . '\').change(); $(document).scrollTop(z.offset().top)">' . $_v['name'] . '</a>';
            if (isset($_md['requires']) && strlen($_md['requires']) > 0) {
                $dat[2]['title'] .= '<br><small>Requires: ' . str_replace(array(',', ':'), array(', ', ': '), $_md['requires']) . '</small>';
            }
            $dat[3]['title'] = $_v['directory'];
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrCore_page_button($_v['directory'], $_v['local'], "window.open('{$_conf['jrCore_base_url']}/modules/{$_v['directory']}/changelog.txt?_v=" . time() . "')");
            $dat[4]['class'] = (jrDeveloper_ver_compare($_v['local'], $_v['market']) == 'greater') ? 'center success' : 'center';
            $dat[5]['title'] = (!empty($_v['market'])) ? $_v['market'] : '-';
            $dat[5]['class'] = (jrDeveloper_ver_compare($_v['market'], $_v['local']) == 'greater') ? 'center error' : 'center';
            jrCore_page_table_row($dat);
        }

        jrCore_page_table_footer();
    }

    // Get all ZIPs in media dir
    $mdir = jrCore_get_media_directory(0, FORCE_LOCAL);
    $_mds = glob("{$mdir}/{$_conf['jrDeveloper_developer_prefix']}*.zip");
    foreach ($_mds as $k => $file) {
        $nam = basename($file);
        list($mod_dir,) = explode('-', $nam, 2);
        if (!isset($_mods[$mod_dir])) {
            unset($_mds[$k]);
        }
    }

    $btn = '';
    if ($_mds && is_array($_mds) && count($_mds) > 0) {
        $btn = jrCore_page_button('del', 'delete all zip files', "jrCore_confirm('Delete all ZIP Files?', 'Are you sure you want to delete all the ZIP files that have been created?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/delete_all/module') })");
    }

    if (empty($_ahead)) {
        if ($missing) {
            $btn .= jrCore_page_button("show-missing", 'Hide Unreleased', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/package_module')");
        }
        else {
            $btn .= jrCore_page_button("show-missing", 'Show Unreleased', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/package_module/show_unreleased=1')");
        }
    }
    jrCore_page_banner('Created ZIP files', $btn);

    // Start our output
    $dat             = array();
    $dat[1]['title'] = 'icon';
    $dat[1]['width'] = '1%';
    $dat[2]['title'] = 'module';
    $dat[2]['width'] = '34%';
    $dat[3]['title'] = 'file';
    $dat[3]['width'] = '20%';
    $dat[4]['title'] = 'license';
    $dat[4]['width'] = '10%';
    $dat[5]['title'] = 'size';
    $dat[5]['width'] = '10%';
    $dat[6]['title'] = 'created';
    $dat[6]['width'] = '15%';
    $dat[7]['title'] = 'download';
    $dat[7]['width'] = '5%';
    $dat[8]['title'] = 'delete';
    $dat[8]['width'] = '5%';
    jrCore_page_table_header($dat);

    // Show existing module packages that can be downloaded
    if (isset($_mds) && is_array($_mds) && count($_mds) > 0) {
        foreach ($_mds as $k => $file) {
            $nam = basename($file);
            list($mod_dir,) = explode('-', $nam, 2);
            $_mt             = jrCore_module_meta_data($mod_dir);
            $dat             = array();
            $dat[1]['title'] = jrCore_get_module_icon_html($mod_dir, 32);
            $dat[2]['title'] = $_mods[$mod_dir]['module_name'];
            $dat[3]['title'] = $nam;
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = (isset($_mt['license'])) ? $_mt['license'] : '?';
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = jrCore_format_size(filesize($file));
            $dat[5]['class'] = 'center';
            $dat[6]['title'] = jrCore_format_time(filemtime($file));
            $dat[6]['class'] = 'center';
            $dat[7]['title'] = jrCore_page_button("d{$k}", 'download', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/download_module/{$nam}')");
            $dat[8]['title'] = jrCore_page_button("r{$k}", 'delete', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/delete_module/{$nam}')");
            jrCore_page_table_row($dat);
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = '<p>No module ZIP files to be downloaded</p>';
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    $_opt = array();
    foreach ($_mods as $m => $v) {
        if (strpos($m, $_conf['jrDeveloper_developer_prefix']) === 0) {
            $_opt[$m] = $v['module_name'];
        }
    }
    if (count($_opt) > 0) {
        asort($_opt);

        // Form init
        $_tmp = array(
            'submit_value'     => 'create module ZIP',
            'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
            'form_ajax_submit' => false

        );
        jrCore_form_create($_tmp);

        $_lic = array(
            'mpl'      => 'Mozilla Public License version 2.0',
            'jcl'      => 'Jamroom Commercial License',
            'mit'      => 'MIT License',
            'freeware' => 'Freeware License (no restrictions)',
        );
        jrCore_page_custom('<div id="zip_license_error" class="page_notice error" style="display:none">Invalid <strong>license</strong> field in the module meta data - ensure the license field is set to one of: ' . implode(', ', array_keys($_lic)) . '</div>');

        $_tmp = array(
            'name'     => 'zip_mod',
            'type'     => 'select',
            'options'  => $_opt,
            'required' => 'on',
            'label'    => 'Module to ZIP',
            'help'     => 'Select the module you would like to create a ZIP file for.  This ZIP file can be used in the Jamroom Marketplace.',
            'onchange' => "var a=this.options[this.selectedIndex].value;jrDeveloper_get_license('module',a);"
        );
        jrCore_form_field_create($_tmp);

        $_tmp = array(
            'name'     => 'zip_license',
            'type'     => 'select',
            'options'  => $_lic,
            'required' => 'on',
            'label'    => 'Module License',
            'help'     => 'Select the license you would like to use for this product.<br><br><strong>Mozilla Public License version 2.0</strong> - recommended for free modules and skins.<br><br><strong>Jamroom Commercial License</strong> - recommended for paid modules and skins.<br><br><strong>MIT License</strong> - user can resell or rebrand without restriction, but must include attribution.<br><br><strong>Freeware License</strong> - no restriction of any kind.'
        );
        jrCore_form_field_create($_tmp);

        $_tmp = array(
            'name'     => 'zip_designer',
            'type'     => 'checkbox',
            'default'  => 'off',
            'required' => false,
            'label'    => 'Export Form Designer',
            'help'     => 'If checked, any fields added with the Form Designer will be included in the modules code when exported. - useful if the module was created via Aparna then fields added via the <strong>Form Designer</strong>.'
        );
        jrCore_form_field_create($_tmp);

    }
    else {
        jrCore_page_notice('error', 'There are no modules found that match your Developer Prefix');
        jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    }

    jrCore_page_display();
}
