<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: reset_system
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_reset_system($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrDeveloper');
    jrCore_set_form_notice('error', "<strong>WARNING!</strong><br>Running this tool will reset the data in your system. <br>The admin profile and its contents will survive. Quotas and their settings will survive. Everything else, GONE!<br>It will truncate and delete your system tables!<br>This is serious!", false);
    jrCore_page_banner('Reset System');

    // Form init
    $_tmp = array(
        'submit_value'  => 'reset system',
        'cancel'        => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'submit_prompt' => 'Are you SURE you want to RESET EVERYTHING except your account? This cannot be undone unless you have a backup!',
        'submit_modal'  => 'update',
        'modal_width'   => 600,
        'modal_height'  => 400,
        'modal_note'    => 'Please be patient while the system is reset'
    );
    jrCore_form_create($_tmp);

    $_tmp = array(
        'name'     => 'reset',
        'type'     => 'checkbox',
        'required' => 'on',
        'default'  => 'off',
        'label'    => 'reset system',
        'help'     => 'Check this box to reset the system.  This will delete all DataStore items except your current User Account and Profile.'
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'rand_ids',
        'type'     => 'checkbox',
        'required' => 'on',
        'default'  => 'off',
        'label'    => 'randomize IDS',
        'help'     => 'If this option is checked, after resetting a table, the auto_increment item ID value will be set to a random number 5 digit number as the starting ID value.'
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
